<?php

namespace Drupal\lightnet_api\Controller;

use Symfony\Component\HttpFoundation\JsonResponse;
use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\contact\Entity\Message;
use Drupal\node\Entity\Node;

class NodeApiController extends ControllerBase {

  protected $entityTypeManager;

  public function __construct(EntityTypeManagerInterface $entityTypeManager) {
    $this->entityTypeManager = $entityTypeManager;
  }

  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('entity_type.manager')
    );
  }

  public function getNode($nid) {

    $node = $this->entityTypeManager
      ->getStorage('node')
      ->load($nid);

    if (!$node) {
      return new JsonResponse(['message' => 'Node not found'], 404);
    }

    $data = [
      'nid' => $node->id(),
      'title' => $node->getTitle(),
      'type' => $node->bundle(),
      'status' => $node->isPublished(),
    ];

    if ($node->hasField('body')) {
      $data['body'] = $node->get('body')->value;
    }

    return new JsonResponse($data);
  }

}